import os
import subprocess

# Konfiguration
BASE_FOLDER = './'  # Hier liegen die Ordner cd01, cd02, ...
OUTPUT_FOLDER = './mp3'
TITLE = ""
AUTHOR = ""
ALBUM = ""


TITLE = input("Titel: ")
AUTHOR = input("Autor: ")
ALBUM = input("Album: ")

os.makedirs(OUTPUT_FOLDER, exist_ok=True)

track_counter = 1

# Finde alle CD-Ordner (cd01, cd02, ...)
cd_folders = sorted([
    f for f in os.listdir(BASE_FOLDER)
    if os.path.isdir(os.path.join(BASE_FOLDER, f)) and f.lower().startswith('cd')
])

for cd in cd_folders:
    cd_path = os.path.join(BASE_FOLDER, cd)
    wav_files = sorted(
        [f for f in os.listdir(cd_path) if f.lower().endswith('.wav')],
        key=lambda x: int(''.join(filter(str.isdigit, x))) or 0
    )

    for wav_file in wav_files:
        wav_path = os.path.join(cd_path, wav_file)
        mp3_filename = f"{track_counter:03d}_{TITLE}.mp3"
        mp3_path = os.path.join(OUTPUT_FOLDER, mp3_filename)

        # Konvertieren
        subprocess.run(['ffmpeg', '-y', '-i', wav_path, mp3_path], check=True)

        # Tags setzen
        title_tag = f"{track_counter:03d}_{TITLE}"
        subprocess.run([
            'id3v2',
            '-t', title_tag,
            '-a', AUTHOR,
            '-A', ALBUM,
            mp3_path
        ], check=True)

        print(f"✅ {wav_file} → {mp3_filename} konvertiert und getaggt")
        track_counter += 1

print("\n🎧 Alle CDs erfolgreich konvertiert!")
